<?php    

include 'config.php';

//get the value of GET parameter 'checkpoint' or die with default '0'
$checkpoint = isset($_GET['checkpoint']) ? $_GET['checkpoint'] : die('you need to provide checkpoint id as parameter ?checkpoint=NUMBER');

//get the url of the self  
$selfurl = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on' ? 'https' : 'http') . '://' . $_SERVER['HTTP_HOST'] . $_SERVER['SCRIPT_NAME'];
//remove the file name
$selfurl = substr($selfurl, 0, strrpos($selfurl, '/') + 1).'checkin.php';
 

if (DEBUG_MODE) {
    echo "<h1>SEC2025 CheckPoint</h1><hr/>";
    echo 'Checkin URL: '.$selfurl.'<hr/>';
}


    
    //set it to writable location, a place for temp generated PNG files
    $PNG_TEMP_DIR = dirname(__FILE__).DIRECTORY_SEPARATOR.'temp'.DIRECTORY_SEPARATOR;
    
    //html PNG location prefix
    $PNG_WEB_DIR = 'temp/';

    include "./phpqrcode/qrlib.php";    
    
    //ofcourse we need rights to create temp dir
    if (!file_exists($PNG_TEMP_DIR))
        mkdir($PNG_TEMP_DIR);
    
    
    $filename = $PNG_TEMP_DIR.'test.png';
    
    //processing form input
    //remember to sanitize user input in real-life solution !!!
    $errorCorrectionLevel='L';
    $matrixPointSize = 10;
    //display text on center of screen
    echo '<div style="text-align: center;">';   
    echo '<h2>QR code for checkpoint '.$checkpoint.'</h2><hr/>';
    echo '</div>';
    $secret=computeSecret($checkpoint);
 
    $payload=$selfurl."?team=YOUR_TEAM&p=".$checkpoint."&secret=".$secret."&t=FILL_HERE&h=FILL_THERE";
    //print the payload as hyperlink
 if (DEBUG_MODE){ 
    echo 'Payload: <a href="'.$payload.'">'.$payload.'</a><hr/>';
 }
 
     // user data
    $filename = $PNG_TEMP_DIR.'test'.md5($payload.'|'.$errorCorrectionLevel.'|'.$matrixPointSize).'.png';
    QRcode::png($payload, $filename, $errorCorrectionLevel, $matrixPointSize, 2);    
    
   
        
    //display generated file in the center of the screen
    echo '<div style="text-align: center;">';   
    echo '<img src="'.$PNG_WEB_DIR.basename($filename).'" /><hr/>';  
    echo '</div>';
    
    
  
        
    // benchmark
    //QRtools::timeBenchmark();    

    