<?php
include 'config.php';

//$conn = getDBConnection();

//get the value of the GET parameter 'teamId' or replace with default 'EMPTY'
$teamId = isset($_GET['team']) ? $_GET['team'] : 'EMPTY';
//get the value of the GET parameter 'p' or replace with default -1
$checkpoint = isset($_GET['p']) ? ($_GET['p']) : -1;
//get the value of the GET parameter 'secret' or replace with default 'EMPTY'
$secret = isset($_GET['secret']) ? $_GET['secret'] : 'EMPTY';
//get the value of the string GET parameter 't' or replace with default -100.0
$temperature = isset($_GET['t']) ? ($_GET['t']) : 'EMPTY';
//get the value of the GET parameter 'h' or replace with default -1.0
$humidity = isset($_GET['h']) ? ($_GET['h']) :'EMPTY';

$localSecret=computeSecret($checkpoint);

$status="NOK";

//get the time of the previous minute too
$timestampPrev = date('Y-m-d H:i', time()-60);
$localSecretPrev=computeSecretTime($checkpoint, $timestampPrev);
//accept also the previous minute hash to allow for small time differences
if ($localSecret != $secret && $localSecretPrev != $secret) {
    if (DEBUG_MODE) echo "Invalid secret! Provided ".$secret." but computed ".$localSecret." or ".$localSecretPrev."<br/>";
    $status="INVALID_SECRET";
}
else{
    if (DEBUG_MODE) echo "Secret is valid!<br/>";
    $status="OK";
}

//log the check-in attempt
$logCsv=$teamId.",".$checkpoint.",".$secret.",".$temperature.",".$humidity.",".$status;
logToFile($logCsv);

//print the values as JSON
$response = array(
    'team' => $teamId,
    'checkpoint' => $checkpoint,
    'secret' => $secret,
    'temperature' => $temperature,
    'humidity' => $humidity,
    'status' => $status
); 
echo json_encode($response);

if (DEBUG_MODE) {
    echo "<hr/>";
    echo "Local secret is ".$localSecret."<br/>";
    echo "Local previous minute secret is ".$localSecretPrev."<br/>";
    echo "Provided secret is ".$secret."<br/>";
    echo "Status is ".$status."<br/>";

    //print the values as a HTML table
    echo "<h1>Check-in for team ".$teamId."</h1>";
    echo "<table border='1'>";
    echo "<tr><th>Checkpoint</th><td>" . htmlspecialchars($checkpoint) . "</td></tr>";
    echo "<tr><th>Secret</th><td>" . htmlspecialchars($secret) . "</td></tr>";
    echo "<tr><th>Temperature</th><td>" . htmlspecialchars($temperature) . "</td></tr>";
    echo "<tr><th>Humidity</th><td>" . htmlspecialchars($humidity) . "</td></tr>";
    echo "</table>";            

}

?>